/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.security;

import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWParticipantList;
import filenet.vw.api.VWSecurityDomain;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import filenet.vw.toolkit.utils.uicontrols.security.VWDomainListCellRenderer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;

public class VWItemFilterPanel
extends JPanel
implements ActionListener,
DocumentListener,
KeyListener,
FocusListener {
    private static final int DEFAULT_BUFFER_SIZE = 500;
    private static final String ACMD_NEW_SEARCH = "NewSearch";
    private Container m_parentContainer = null;
    private VWSession m_vwSession = null;
    private EventListenerList m_listenerList = null;
    private int m_nBufferSize = -1;
    private int m_nSortType = 1;
    private VWSecurityDomain m_defaultSecurityDomain = null;
    private JComboBox m_domainCombo = null;
    private JTextField m_domainTextField = null;
    private JComboBox m_filterCombo = null;
    private JTextField m_filterTextField = null;
    private JButton m_searchButton = null;

    public VWItemFilterPanel(Container parentContainer, VWSession vwSession) {
        this.m_parentContainer = parentContainer;
        this.m_vwSession = vwSession;
        this.m_listenerList = new EventListenerList();
        this.createControls();
    }

    public void addActionListener(ActionListener listener) {
        if (this.m_listenerList != null) {
            this.m_listenerList.add(ActionListener.class, listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        if (this.m_listenerList != null) {
            this.m_listenerList.remove(ActionListener.class, listener);
        }
    }

    public VWParticipantItem[] getUserParticipantItems() throws Exception {
        VWParticipantList vwParticipantList = this.getParticipantList(0);
        if (vwParticipantList != null) {
            return this.getParticipantItemBlock(vwParticipantList);
        }
        return null;
    }

    public VWParticipantItem[] getGroupParticipantItems() throws Exception {
        VWParticipantList vwParticipantList = this.getParticipantList(1);
        if (vwParticipantList != null) {
            return this.getParticipantItemBlock(vwParticipantList);
        }
        return null;
    }

    public void clear() {
        if (this.m_filterTextField != null) {
            this.m_filterTextField.setText("");
        }
    }

    public void setEnabled(boolean bEnable) {
        if (this.m_domainCombo != null) {
            this.m_domainCombo.setEnabled(bEnable);
        }
        if (this.m_filterCombo != null) {
            this.m_filterCombo.setEnabled(bEnable);
        }
        if (this.m_filterTextField != null && this.m_searchButton != null) {
            this.m_filterTextField.setEnabled(bEnable);
            boolean bHasFilterString = this.m_filterTextField.getDocument().getLength() > 0;
            this.m_searchButton.setEnabled(bHasFilterString && bEnable);
        }
    }

    public void removeReferences() {
        this.m_domainCombo = null;
        this.m_domainTextField = null;
        if (this.m_filterCombo != null) {
            this.m_filterCombo.removeActionListener(this);
            this.m_filterCombo = null;
        }
        if (this.m_filterTextField != null) {
            this.m_filterTextField.getDocument().removeDocumentListener(this);
            this.m_filterTextField.removeKeyListener(this);
            this.m_filterTextField = null;
        }
        if (this.m_searchButton != null) {
            this.m_searchButton.removeActionListener(this);
            this.m_searchButton = null;
        }
        this.m_parentContainer = null;
        this.m_vwSession = null;
        this.m_listenerList = null;
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.m_searchButton)) {
            this.fireActionEvent(ACMD_NEW_SEARCH);
        }
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void insertUpdate(DocumentEvent event) {
        if (event.getDocument() == this.m_filterTextField.getDocument()) {
            this.setEnabled(true);
        }
    }

    public void removeUpdate(DocumentEvent event) {
        if (event.getDocument() == this.m_filterTextField.getDocument()) {
            this.setEnabled(true);
        }
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
        if (event.getKeyCode() == 10 && this.m_searchButton.isEnabled()) {
            this.fireActionEvent(ACMD_NEW_SEARCH);
        }
    }

    public void keyTyped(KeyEvent event) {
    }

    private void createControls() {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(0, 0, 3, 3);
            VWSecurityDomain[] vwSecurityDomains = this.m_vwSession.fetchSecurityDomains();
            if (vwSecurityDomains != null && vwSecurityDomains.length > 0) {
                JLabel selectInLabel = new JLabel(VWResource.s_colon.toString(VWResource.s_selectIn));
                this.add((Component)selectInLabel, gbCons);
                VWAccessibilityHelper.setAccessibility(selectInLabel, this, selectInLabel.getText(), selectInLabel.getText());
                ++gbCons.gridx;
                gbCons.gridwidth = 0;
                gbCons.fill = 2;
                gbCons.weightx = 1.0;
                if (vwSecurityDomains.length == 1) {
                    this.m_defaultSecurityDomain = vwSecurityDomains[0];
                    this.m_domainTextField = new JTextField(VWDomainListCellRenderer.getDomainName(vwSecurityDomains[0]));
                    this.m_domainTextField.setName("m_domainTextField_VWItemFilterPanel");
                    this.m_domainTextField.setToolTipText(vwSecurityDomains[0].toString());
                    this.m_domainTextField.setCaretPosition(0);
                    this.m_domainTextField.setEditable(false);
                    this.m_domainTextField.addFocusListener(this);
                    this.add((Component)this.m_domainTextField, gbCons);
                    VWAccessibilityHelper.setAccessibility(this.m_domainTextField, this, selectInLabel.getText() + this.m_domainTextField.getText(), selectInLabel.getText() + this.m_domainTextField.getText());
                } else {
                    this.m_domainCombo = new JComboBox<VWSecurityDomain>(vwSecurityDomains);
                    this.m_domainCombo.setName("m_domainCombo_VWItemFilterPanel");
                    this.m_domainCombo.setRenderer(new VWDomainListCellRenderer());
                    this.add((Component)this.m_domainCombo, gbCons);
                    this.m_defaultSecurityDomain = this.m_vwSession.getDefaultSecurityDomain();
                    this.m_domainCombo.setSelectedItem(this.m_defaultSecurityDomain);
                    VWAccessibilityHelper.setAccessibility(this.m_domainCombo, this, VWResource.s_securityDomain, VWResource.s_securityDomain);
                }
                ++gbCons.gridy;
            }
            gbCons.gridx = 0;
            gbCons.gridwidth = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            JLabel startWithLabel = null;
            startWithLabel = new JLabel(VWResource.s_startsWith);
            this.add((Component)startWithLabel, gbCons);
            ++gbCons.gridx;
            gbCons.weightx = 1.0;
            gbCons.fill = 2;
            this.m_filterTextField = new JTextField();
            this.m_filterTextField.setName("m_filterTextField_VWItemFilterPanel");
            this.m_filterTextField.getDocument().addDocumentListener(this);
            this.m_filterTextField.addKeyListener(this);
            this.add((Component)this.m_filterTextField, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_filterTextField, this, VWResource.s_startsWith, VWResource.s_startsWith);
            if (startWithLabel != null) {
                VWAccessibilityHelper.setAccessibility(startWithLabel, this, startWithLabel.getText(), startWithLabel.getText());
                VWAccessibilityHelper.setLabelFor(startWithLabel, this.m_filterTextField);
            }
            ++gbCons.gridx;
            gbCons.weightx = 0.0;
            gbCons.fill = 0;
            this.m_searchButton = new JButton(VWImageLoader.createImageIcon("search.gif"));
            this.m_searchButton.setName("m_searchButton_VWItemFilterPanel");
            this.m_searchButton.addActionListener(this);
            this.m_searchButton.setToolTipText(VWResource.s_search);
            this.m_searchButton.setMargin(new Insets(1, 1, 1, 1));
            this.m_searchButton.setEnabled(false);
            VWAccessibilityHelper.setAccessibility(this.m_searchButton, this, VWResource.s_search, VWResource.s_search);
            this.m_searchButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.add((Component)this.m_searchButton, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void fireActionEvent(String actionCommand) {
        ActionEvent event = new ActionEvent(this, 1001, actionCommand);
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    private int getFilterType() {
        String temp = this.m_filterTextField.getText();
        if (temp != null && temp.length() > 0) {
            if (this.m_filterCombo == null) {
                return 2;
            }
            switch (this.m_filterCombo.getSelectedIndex()) {
                case 0: {
                    return 2;
                }
                case 1: {
                    return 3;
                }
                case 2: {
                    return 4;
                }
            }
        }
        return 0;
    }

    private int getBufferSize() {
        block7: {
            try {
                if (this.m_nBufferSize == -1) {
                    Object property = VWIDMBaseFactory.instance().getProperties().getProperty("sitePreferences");
                    if (property == null) break block7;
                    try {
                        Method m = property.getClass().getMethod("getGranteeMaximumFilterSize", new Class[0]);
                        Integer i = (Integer)m.invoke(property, null);
                        if (i != null) {
                            this.m_nBufferSize = i;
                        }
                        if (this.m_nBufferSize > 0) {
                            return this.m_nBufferSize;
                        }
                        break block7;
                    }
                    catch (Throwable t) {
                        this.m_nBufferSize = 500;
                    }
                    break block7;
                }
                return this.m_nBufferSize;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return 500;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private VWParticipantList getParticipantList(int nParticipantType) throws Exception {
        VWParticipantList vwParticipantList = null;
        if (this.m_parentContainer != null) {
            this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(3));
        }
        try {
            try {
                vwParticipantList = this.getParticipantListFromServer(nParticipantType);
            }
            catch (VWException ex) {
                if (this.m_nSortType != 1) throw ex;
                this.m_nSortType = 0;
                vwParticipantList = this.getParticipantListFromServer(nParticipantType);
                Object var5_4 = null;
                if (this.m_parentContainer == null) return vwParticipantList;
                this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(0));
                return vwParticipantList;
            }
            Object var5_3 = null;
            if (this.m_parentContainer == null) return vwParticipantList;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.m_parentContainer == null) throw throwable;
            this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(0));
            throw throwable;
        }
        this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(0));
        return vwParticipantList;
    }

    private VWParticipantList getParticipantListFromServer(int nParticipantType) throws Exception {
        VWParticipantList vwParticipantList = null;
        String domainName = null;
        if (this.m_vwSession == null) {
            return null;
        }
        domainName = this.m_domainCombo != null ? ((VWSecurityDomain)this.m_domainCombo.getSelectedItem()).getDomainName() : this.m_defaultSecurityDomain.getDomainName();
        switch (nParticipantType) {
            case 0: {
                vwParticipantList = this.m_vwSession.findUsersByDomain(domainName, this.m_filterTextField.getText(), this.getFilterType(), this.m_nSortType, this.getBufferSize() + 1);
                break;
            }
            case 1: {
                vwParticipantList = this.m_vwSession.findGroupsByDomain(domainName, this.m_filterTextField.getText(), this.getFilterType(), this.m_nSortType, this.getBufferSize() + 1);
            }
        }
        if (vwParticipantList != null) {
            vwParticipantList.hasNext();
        }
        return vwParticipantList;
    }

    private VWParticipantItem[] getParticipantItemBlock(VWParticipantList vwParticipantList) throws Exception {
        Object[] participantItems = null;
        if (vwParticipantList != null) {
            Vector<VWParticipantItem> items = new Vector<VWParticipantItem>();
            int nCount = this.getBufferSize();
            while (vwParticipantList.hasNext()) {
                if (--nCount < 0) {
                    VWMessageDialog.showOptionDialog(JOptionPane.getFrameForComponent(this.m_parentContainer), VWResource.s_bufferOverrun, 3);
                    break;
                }
                items.addElement(new VWParticipantItem((VWParticipant)vwParticipantList.next()));
            }
            if (items.size() > 0) {
                participantItems = new VWParticipantItem[items.size()];
                items.copyInto(participantItems);
                if (this.m_nSortType == 0) {
                    VWQubbleSort.sort(participantItems);
                }
            }
        }
        return participantItems;
    }

    public void focusGained(FocusEvent e) {
        Object source = e.getSource();
        if (source instanceof JTextField && !((JTextField)source).isEditable()) {
            ((JTextField)source).setBorder(BorderFactory.createEtchedBorder());
        }
    }

    public void focusLost(FocusEvent e) {
        Object source = e.getSource();
        if (source instanceof JTextField && !((JTextField)source).isEditable()) {
            ((JTextField)source).setBorder(null);
        }
    }
}

